package com.geotab.model.entity.group;

import com.geotab.model.Id;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * This is a {@link SystemSecurityClearance} with an Id of GroupViewOnlySecurityId. A user that have their security
 * assigned to this group will only have access to view local data in the system. This user is unable to *modify* any
 * data in the system and is the type of access that is recommended for users that need to view data in reports,
 * tracking etc.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "viewOnlySecurityGroupBuilder")
public class ViewOnlySecurityGroup extends SystemSecurityClearance {

  public static final String VIEW_ONLY_SECURITY_GROUP_ID = "GroupViewOnlySecurityId";
  public static final String VIEW_ONLY_SECURITY_GROUP_NAME = "**ViewOnlySecurity**";

  {
    setId(new Id(VIEW_ONLY_SECURITY_GROUP_ID));
    setName(VIEW_ONLY_SECURITY_GROUP_NAME);
  }
}
