package com.geotab.model.entity.groupfilter;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.geotab.model.search.Search;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * GroupFilterCondition class represents a group filter condition, or a list of conditions with a logical operator.
 * The conditions create a tree structure. The root node is the top level condition, and the leaf nodes are the
 * conditions with a groupId.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class GroupFilterCondition implements Search {

  private String id;

  /**
   * Whether the ReportTemplate is negated.
   */
  @JsonProperty("isNegated")
  private Boolean isNegated;

  /**
   * The {@link SearchRelation}.
   */
  private SearchRelation relation;

  /**
   * The list of {@link GroupFilterCondition}(s).
   */
  @JsonProperty("groupFilterConditions")
  protected List<GroupFilterCondition> groupFilterConditions;

  /**
   * The group id.
   */
  @JsonProperty("groupId")
  private String groupId;

  /**
   * The {@link IncludeGroups}.
   */
  @JsonProperty("includeGroups")
  private IncludeGroups includeGroups;

  /**
   * The parent {@link GroupFilterCondition}.
   */
  private GroupFilterCondition parent;
}
