/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.hos;

import com.geotab.model.entity.EntityWithVersion;
import com.geotab.model.entity.user.User;
import java.time.Duration;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A user's Hos Ruleset.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class UserHosRuleSet extends EntityWithVersion {

  /**
   * The ruleset.
   */
  private HosRuleSetNew hosRuleSet;

  /**
   * The user.
   */
  private User user;

  /**
   * The active from.
   */
  private LocalDateTime dateTime;

  /**
   * The start of day.
   */
  private Duration startOfDay;
}
