package com.geotab.model.entity.ioxaddonstatus;

import com.geotab.model.Id;
import com.geotab.model.entity.EntityWithVersion;
import com.geotab.model.entity.device.Device;
import com.geotab.model.entity.deviceconnectionstatus.DeviceConnectionStatus;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Represents the status of an IoxAddOn that is attached to a GO unit.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class IoxAddOnStatus extends EntityWithVersion {

  /**
   * The {@link Device} related to the IoxAddOnStatus.
   */
  private Device device;

  /**
   * The {@link DeviceConnectionStatus}.
   */
  private DeviceConnectionStatus deviceConnectionStatus;

  /**
   * The date/time of last IOX/passthrough communication for the device.
   */
  private LocalDateTime lastCommunicated;

  /**
   * The date/time of when the message was delivered.
   */
  private LocalDateTime delivered;

  /**
   * The queue size of pending messages.
   */
  private int queueSize;

  public IoxAddOnStatus(String id) {
    setId(new Id(id));
  }
}
