/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.notification;

import com.geotab.model.Id;
import lombok.Data;

/**
 * Default exception rule popup text.
 */
@Data
public final class DefaultExceptionRulePopupTextTemplate extends TextTemplate {

  private static class InstanceHolder {

    private static final DefaultExceptionRulePopupTextTemplate INSTANCE = new DefaultExceptionRulePopupTextTemplate();
  }

  public static final String TEXT_TEMPLATE_DEFAULT_EXCEPTION_RULE_POPUP_ID = "TextTemplateDefaultExceptionRulePopupId";

  private DefaultExceptionRulePopupTextTemplate() {
    setId(new Id(TEXT_TEMPLATE_DEFAULT_EXCEPTION_RULE_POPUP_ID));
    setName("DefaultExceptionRulePopupTextTemplate");
    setText("{device} broke the rule '{rule}'");
  }

  public static DefaultExceptionRulePopupTextTemplate getInstance() {
    return DefaultExceptionRulePopupTextTemplate.InstanceHolder.INSTANCE;
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }
}
