/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.notification;

import com.geotab.model.Id;
import lombok.Data;

/**
 * Default exception rule text.
 */
@Data
public final class DefaultExceptionRuleTextTemplate extends TextTemplate {

  private static class InstanceHolder {

    private static final DefaultExceptionRuleTextTemplate INSTANCE = new DefaultExceptionRuleTextTemplate();
  }

  public static final String TEXT_TEMPLATE_DEFAULT_EXCEPTION_RULE_ID = "TextTemplateDefaultExceptionRuleId";

  private DefaultExceptionRuleTextTemplate() {
    setId(new Id(TEXT_TEMPLATE_DEFAULT_EXCEPTION_RULE_ID));
    setName("DefaultExceptionRuleTextTemplate");
    setText("{rule}");
  }

  public static DefaultExceptionRuleTextTemplate getInstance() {
    return DefaultExceptionRuleTextTemplate.InstanceHolder.INSTANCE;
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }
}
