/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.notification;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;

public enum MediaFileType implements HasName {

  /**
   * Fallback when enumeration value is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown", -1),

  /**
   * .wav file (sound file).
   */
  WAV("Wav", 0),

  /**
   * User template for format of exception notification emails.
   */
  NOTIFICATION_EMAIL_TEMPLATE("NotificationEmailTemplate", 1),

  /**
   * User template for format of notification web requests.
   */
  WEB_REQUEST_TEMPLATE("WebRequestTemplate", 2),

  /**
   * User template for format of notification web requests.
   */
  TEXT_TEMPLATE("TextTemplate", 3);

  private final String name;
  private final int code;

  MediaFileType(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }
}
