/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.notification;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.serialization.ByteArrayDeserializer;
import com.geotab.model.serialization.ByteArraySerializer;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Custom Notification Alert sound.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "notificationAudioAlarmFileBuilder")
public class NotificationAudioAlarmFile extends NotificationBinaryFile {

  /**
   * The binary data.
   */
  @JsonDeserialize(using = ByteArrayDeserializer.class)
  @JsonSerialize(using = ByteArraySerializer.class)
  private Byte[] binaryData;

  {
    setType(NotificationBinaryFileType.AUDIO_ALARM_FILE);
  }
}
