/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.notification;

import static com.fasterxml.jackson.annotation.JsonTypeInfo.As.EXISTING_PROPERTY;
import static com.fasterxml.jackson.annotation.JsonTypeInfo.Id.NAME;
import static com.geotab.model.entity.notification.DefaultApplicationExceptionEmailTemplate.EMAIL_TEMPLATE_DEFAULT_APPLICATION_EXCEPTION_ID;
import static com.geotab.model.entity.notification.DefaultExceptionRuleEmailTemplate.EMAIL_TEMPLATE_DEFAULT_EXCEPTION_RULE_ID;
import static com.geotab.model.entity.notification.DefaultExceptionRulePopupTextTemplate.TEXT_TEMPLATE_DEFAULT_EXCEPTION_RULE_POPUP_ID;
import static com.geotab.model.entity.notification.DefaultExceptionRuleTextTemplate.TEXT_TEMPLATE_DEFAULT_EXCEPTION_RULE_ID;
import static com.geotab.model.entity.notification.NotificationBinaryFile.AUDIO_ALARM_FILE;
import static com.geotab.model.entity.notification.NotificationBinaryFile.EMAIL_TEMPLATE;
import static com.geotab.model.entity.notification.NotificationBinaryFile.TEXT_TEMPLATE;
import static com.geotab.model.entity.notification.NotificationBinaryFile.WEB_REQUEST_TEMPLATE;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonSubTypes.Type;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.geotab.model.Id;
import com.geotab.model.entity.NameEntity;
import com.geotab.util.Util;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Notification binary file.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "notificationBinaryFileBuilder")
@JsonTypeInfo(use = NAME, include = EXISTING_PROPERTY, property = "type", visible = true,
    defaultImpl = NotificationBinaryFile.class)
@JsonSubTypes({
    @Type(value = NotificationAudioAlarmFile.class, name = AUDIO_ALARM_FILE),
    @Type(value = EmailTemplate.class, name = EMAIL_TEMPLATE),
    @Type(value = WebRequestTemplate.class, name = WEB_REQUEST_TEMPLATE),
    @Type(value = TextTemplate.class, name = TEXT_TEMPLATE)
})
public class NotificationBinaryFile extends NameEntity {

  public static final String AUDIO_ALARM_FILE = "AudioAlarmFile";
  public static final String EMAIL_TEMPLATE = "EmailTemplate";
  public static final String WEB_REQUEST_TEMPLATE = "WebRequestTemplate";
  public static final String TEXT_TEMPLATE = "TextTemplate";

  /**
   * The media file type.
   */
  private MediaFileType fileType;

  /**
   * The type of the binary data for notifications.
   */
  private NotificationBinaryFileType type;

  /**
   * The notification template purpose.
   */
  private NotificationTemplatePurpose purpose;

  public NotificationBinaryFile(String id) {
    setId(new Id(id));
    setName(id);
  }

  public static NotificationBinaryFile fromSystem(String id) {
    if (Util.isEmpty(id)) return null;
    switch (id) {
      case EMAIL_TEMPLATE_DEFAULT_APPLICATION_EXCEPTION_ID:
        return DefaultApplicationExceptionEmailTemplate.getInstance();
      case EMAIL_TEMPLATE_DEFAULT_EXCEPTION_RULE_ID:
        return DefaultExceptionRuleEmailTemplate.getInstance();
      case TEXT_TEMPLATE_DEFAULT_EXCEPTION_RULE_ID:
        return DefaultExceptionRuleTextTemplate.getInstance();
      case TEXT_TEMPLATE_DEFAULT_EXCEPTION_RULE_POPUP_ID:
        return DefaultExceptionRulePopupTextTemplate.getInstance();
      default:
        return null;
    }
  }
}
