/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.notification;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Custom text notifications.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "textTemplateBuilder")
public class TextTemplate extends NotificationBinaryFile {

  /**
   * The text.
   */
  private String text;

  {
    setFileType(MediaFileType.TEXT_TEMPLATE);
    setType(NotificationBinaryFileType.TEXT_TEMPLATE);
  }
}
