/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.notification;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;

public enum WebRequestTemplateHttpVerb implements HasName {

  /**
   * Fallback when enumeration value is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown"),

  /**
   * The get http verb.
   */
  GET("Get"),

  /**
   * The post http verb.
   */
  POST("Post");

  private final String name;

  WebRequestTemplateHttpVerb(String name) {
    this.name = name;
  }

  @JsonValue
  public String getName() {
    return name;
  }
}
