/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.parametergroup;

import static com.geotab.model.entity.parametergroup.ParameterGroupNone.PARAMETER_GROUP_NONE_ID;

import com.geotab.model.Id;
import com.geotab.model.entity.NameEntity;
import com.geotab.util.Util;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Standard Parameter Group Number (PGN). Where there is no parameter group it is represented by
 * "ParameterGroupNoneId".
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "parameterGroupBuilder")
public class ParameterGroup extends NameEntity {

  /**
   * The unique code of the PGN.
   */
  private Integer code;

  /**
   * The total length in bytes of the PGN.
   */
  private Integer dataLength;

  public ParameterGroup(String id) {
    setId(new Id(id));
    setName(id);
  }

  public static ParameterGroup fromSystem(String id) {
    if (Util.isEmpty(id)) return null;
    if (PARAMETER_GROUP_NONE_ID.equalsIgnoreCase(id)) return ParameterGroupNone.getInstance();
    return null;
  }
}
