/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.parametergroup;

import com.geotab.model.Id;
import com.geotab.model.serialization.SystemEntitySerializationAware;
import lombok.Data;

/**
 * A parameter group to use where there is no parameter group.
 */
@Data
public final class ParameterGroupNone extends ParameterGroup implements SystemEntitySerializationAware {

  private static class InstanceHolder {

    private static final ParameterGroupNone INSTANCE = new ParameterGroupNone();
  }

  public static final String PARAMETER_GROUP_NONE_ID = "ParameterGroupNoneId";

  private ParameterGroupNone() {
    setId(new Id(PARAMETER_GROUP_NONE_ID));
    setName("**None");
    setCode(0);
    setDataLength(0);
  }

  public static ParameterGroupNone getInstance() {
    return InstanceHolder.INSTANCE;
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }
}
