/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.recipient;

import com.geotab.model.Id;
import com.geotab.model.serialization.SystemEntitySerializationAware;
import lombok.Data;

/**
 * No Recipient.
 */
@Data
public class NoRecipient extends Recipient implements SystemEntitySerializationAware {

  private static class InstanceHolder {

    private static final NoRecipient INSTANCE = new NoRecipient();
  }

  public static final String NO_RECIPIENT_ID = "NoRecipientId";

  private NoRecipient() {
    setId(new Id(NO_RECIPIENT_ID));
    setRecipientType(RecipientType.LOG_ONLY);
  }

  public static NoRecipient getInstance() {
    return NoRecipient.InstanceHolder.INSTANCE;
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }
}
