/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.reporttemplate;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;

public enum ReportDataSource implements HasName {

  /**
   * Fallback when enumeration value is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown", -1),

  /**
   * Used for other preloaded templates.
   */
  TRIPS_DETAIL("TripsDetail", 1),

  /**
   * Risk management report.
   */
  RISK_MANAGEMENT("RiskManagement", 2),

  /**
   * Exceptions Details report.
   */
  EXCEPTIONS_DETAIL("ExceptionsDetail", 3),

  /**
   * Exceptions Details report.
   */
  DEBUG("Debug", 4),

  /**
   * Exceptions Summary report.
   */
  EXCEPTIONS_SUMMARY("ExceptionsSummary", 5),

  /**
   * Trips Summary report.
   */
  TRIPS_SUMMARY("TripsSummary", 6),

  /**
   * Time card report.
   */
  TIME_CARD("TimeCard", 7),

  /**
   * Audit Log list.
   */
  AUDIT_LOG("AuditLog", 9),

  /**
   * User list.
   */
  USER_LIST("UserList", 10),

  /**
   * Diagnostic list.
   */
  DIAGNOSTIC_LIST("DiagnosticList", 13),

  /**
   * Zone visit detail report.
   */
  ZONE_VISITS_DETAIL("ZoneVisitsDetail", 14),

  /**
   * Customer visit summary report.
   */
  ZONE_VISITS_SUMMARY("ZoneVisitsSummary", 15),

  /**
   * Route summary report.
   */
  ROUTE_SUMMARY("RouteSummary", 16),

  /**
   * Unassigned route report.
   */
  UNASSIGNED_ROUTE("UnassignedRoute", 17),

  /**
   * Notification list.
   */
  NOTIFICATION("Notification", 18),

  /**
   * Fuel tax report.
   */
  FUEL_TAX("FuelTax", 19),

  /**
   * Zones List.
   */
  ZONE_LIST("ZoneList", 20),

  /**
   * Congregation report.
   */
  CONGREGATION("Congregation", 21),

  /**
   * Engine summary report.
   */
  ENGINE_SUMMARY("EngineSummary", 24),

  /**
   * Engine fault summary report.
   */
  ENGINE_FAULT("EngineFault", 25),

  /**
   * Engine status summary report.
   */
  ENGINE_STATUS("EngineStatus", 26),

  /**
   * Device report.
   */
  DEVICE("Device", 27),

  /**
   * Route direction report.
   */
  ROUTE_DIRECTIONS("RouteDirections", 28),

  /**
   * Reminder report.
   */
  REMINDER("Reminder", 29),

  /**
   * EventRule device report.
   */
  EVENT_RULE_DEVICE("EventRuleDevice", 30),

  /**
   * Event history report.
   */
  EVENT_HISTORY("EventHistory", 31),

  /**
   * Groups list.
   */
  GROUPS_LIST("GroupsList", 32),

  /**
   * DeviceInstall History report.
   */
  DEVICE_INSTALL_HISTORY("DeviceInstallHistory", 34),

  /**
   * Engine Status statistics report.
   */
  ENGINE_STATUS_STATISTICS("EngineStatusStatistics", 37),

  /**
   * Text Message.
   */
  TEXT_MESSAGE("TextMessage", 38),

  /**
   * Route Comparison report.
   */
  ROUTE_COMPARISON_DETAIL("RouteComparisonDetail", 39),

  /**
   * HOS drivers log report.
   */
  HOS_LOG("HosLog", 40),

  /**
   * Driver Vehicle Inspection Report.
   */
  DVIR_LOG("DVIRLog", 41),

  /**
   * HOS violation.
   */
  HOS_VIOLATION("HosViolation", 42),

  /**
   * Exceptions Summary Graph.
   */
  EXCEPTIONS_SUMMARY_GRAPH("ExceptionsSummaryGraph", 43),

  /**
   * Trips Idling Summary Graph.
   */
  TRIPS_IDLING_SUMMARY_GRAPH("TripsIdlingSummaryGraph", 44),

  /**
   * Fleet Summary Graph.
   */
  FLEET_SUMMARY_GRAPH("FleetSummaryGraph", 45),

  /**
   * Customer Stop Graph.
   */
  CUSTOMER_STOP_GRAPH("CustomerStopGraph", 46),

  /**
   * Trips Density Summary Graph.
   */
  TRIPS_DENSITY_SUMMARY_GRAPH("TripsDensitySummaryGraph", 47),

  /**
   * Fill-ups report.
   */
  FILL_UPS("FillUps", 48),

  /**
   * HOS availability.
   */
  HOS_AVAILABILITY("HosAvailability", 49),

  /**
   * Charging events.
   */
  CHARGE_EVENT("ChargeEvent", 50),

  /**
   * Material management report.
   */
  MATERIAL_MANAGEMENT("MaterialManagement", 51),

  /**
   * Route completion report.
   */
  ROUTE_COMPLETION("RouteCompletion", 52),

  /**
   * EV battery health.
   */
  EV_BATTERY_HEALTH("EVBatteryHealth", 53);

  private final String name;
  private final int code;

  ReportDataSource(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }
}
