/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.reporttemplate;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;

public enum ReportTemplateType implements HasName {

  /**
   * Fallback when enumeration value is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown", -1),

  /**
   * Uploaded user reports.
   */
  CUSTOM("Custom", 0),

  /**
   * Exportable report view with simplified columns.
   */
  REPORT("Report", 1),

  /**
   * Exportable report views with all columns.
   */
  ADVANCED("Advanced", 2),

  /**
   * Default dashboard.
   */
  DASHBOARD("Dashboard", 3),

  /**
   * Used for other preloaded templates.
   */
  PRELOADED("Preloaded", 4);

  private final String name;
  private final int code;

  ReportTemplateType(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }
}
