/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.route;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.geotab.model.entity.Entity;
import com.geotab.model.entity.zone.Zone;
import java.time.Duration;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The class representing an individual item in a planned {@link Route}.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class RoutePlanItem extends Entity {

  /**
   * The start date for the plan item.
   */
  private LocalDateTime activeFrom;

  /**
   * The end date for the plan item.
   */
  private LocalDateTime activeTo;

  /**
   * Expected trip distance to arrival.
   */
  private Float expectedDistanceToArrival;

  /**
   * Expected stop duration.
   */
  private Duration expectedStopDuration;

  /**
   * Expected trip time to arrival.
   */
  private Duration expectedTripDurationToArrival;

  /**
   * The associated {@link Route} of the plan.
   */
  @JsonIgnore
  private Route route;

  /**
   * The sequence number of the plan item.
   */
  private Integer sequence;

  /**
   * The associated {@link Zone} in the route.
   */
  private Zone zone;

  /**
   * Expected date and time of arrival.
   */
  private LocalDateTime dateTime;

  /**
   * The expected number of passes through the {@link Zone}.
   */
  private Integer passCount;
}
