/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.rule;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;

public enum ExceptionRuleCategory implements HasName {

  /**
   * Fallback when enumeration value is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown"),

  /**
   * An Application Exception Rule.
   */
  APPLICATION_EXCEPTION_RULE("ApplicationExceptionRule"),

  /**
   * A user management Exception Rule that includes either engine and non-engine rules or combination of them.
   */
  USER_EXCEPTION_RULES("UserExceptionRules"),

  /**
   * An Exception Rule associated with a Customer Zone.
   */
  ZONE_STOP_EXCEPTION_RULES("ZoneStopExceptionRules");

  private final String name;

  ExceptionRuleCategory(String name) {
    this.name = name;
  }

  @JsonValue
  public String getName() {
    return name;
  }
}
