/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.rule;

import com.geotab.model.Id;
import com.geotab.model.serialization.SystemEntitySerializationAware;
import lombok.Data;

/**
 * A Exception Rule which represents no value.
 */
@Data
public class NoRule extends Rule implements SystemEntitySerializationAware {

  private static class InstanceHolder {

    private static final NoRule INSTANCE = new NoRule();
  }

  public static final String NO_RULE_ID = "NoRuleId";

  private NoRule() {
    setId(new Id(NO_RULE_ID));
    setName("***No Rule");
    setVersion(0L);
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }

  public static NoRule getInstance() {
    return NoRule.InstanceHolder.INSTANCE;
  }
}
