/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.shipmentlog;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.entity.EntityWithVersion;
import com.geotab.model.entity.device.Device;
import com.geotab.model.entity.user.User;
import com.geotab.model.serialization.EntityAsIdSerializer;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A ShipmentLog is a record of shipment transported by a specified vehicle for a duration of time.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class ShipmentLog extends EntityWithVersion {

  /**
   * The {@link Device} associated with this log.
   */
  private Device device;

  /**
   * The date the shipment was started. Default [UtcNow].
   */
  private LocalDateTime activeFrom;

  /**
   * The date the shipment was ended. Default [UtcNow].
   */
  private LocalDateTime activeTo;

  /**
   * The commodity shipped. Maximum length [255] Default [""].
   */
  private String commodity;

  /**
   * The identifier of the shipment document. Default [""].
   */
  private String documentNumber;

  /**
   * The name of the shipper. Default [""].
   */
  private String shipperName;

  /**
   * The date and time the log was created.
   */
  private LocalDateTime dateTime;

  /**
   * The {@link User} who created this log.
   */
  @JsonSerialize(using = EntityAsIdSerializer.class)
  private User driver;
}
