/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import static com.geotab.model.entity.source.SourceAiModel.SOURCE_AI_MODEL_ID;
import static com.geotab.model.entity.source.SourceAiModelObsolete.SOURCE_AI_MODEL_OBSOLETE_ID;
import static com.geotab.model.entity.source.SourceBrp.SOURCE_BRP_ID;
import static com.geotab.model.entity.source.SourceBrpObsolete.SOURCE_BRP_OBSOLETE_ID;
import static com.geotab.model.entity.source.SourceGmccc.SOURCE_GMCCC_ID;
import static com.geotab.model.entity.source.SourceGmcccObsolete.SOURCE_GMCCC_OBSOLETE_ID;
import static com.geotab.model.entity.source.SourceGo.SOURCE_GEOTAB_GO_ID;
import static com.geotab.model.entity.source.SourceGoObsolete.GEOTAB_GO_OBSOLETE_ID;
import static com.geotab.model.entity.source.SourceJ1708.SOURCE_J1708_ID;
import static com.geotab.model.entity.source.SourceJ1708Obsolete.SOURCE_J1708_OBSOLETE_ID;
import static com.geotab.model.entity.source.SourceJ1939.SOURCE_J1939_ID;
import static com.geotab.model.entity.source.SourceJ1939Obsolete.SOURCE_J1939_OBSOLETE_ID;
import static com.geotab.model.entity.source.SourceLegacy.SOURCE_LEGACY_ID;
import static com.geotab.model.entity.source.SourceLegacyObsolete.SOURCE_LEGACY_OBSOLETE_ID;
import static com.geotab.model.entity.source.SourceLevc.SOURCE_LECV_ID;
import static com.geotab.model.entity.source.SourceLevcObsolete.SOURCE_LECV_OBSOLETE_ID;
import static com.geotab.model.entity.source.SourceObd.SOURCE_OBD_ID;
import static com.geotab.model.entity.source.SourceObdObsolete.SOURCE_OBD_OBSOLETE_ID;
import static com.geotab.model.entity.source.SourceObdSa.SOURCE_OBD_SA_ID;
import static com.geotab.model.entity.source.SourceObdSaObsolete.SOURCE_OBD_SA_OBSOLETE_ID;
import static com.geotab.model.entity.source.SourceProprietary.SOURCE_PROPRIETARY_ID;
import static com.geotab.model.entity.source.SourceProprietaryObsolete.SOURCE_PROPRIETARY_OBSOLETE_ID;
import static com.geotab.model.entity.source.SourceSystem.SOURCE_SYSTEM_ID;
import static com.geotab.model.entity.source.SourceSystemObsolete.SOURCE_SYSTEM_OBSOLETE_ID;
import static com.geotab.model.entity.source.SourceThirdParty.SOURCE_THIRD_PARTY_ID;
import static com.geotab.model.entity.source.SourceThirdPartyObsolete.SOURCE_THIRD_PARTY_OBSOLETE_ID;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.Id;
import com.geotab.model.entity.NameEntity;
import com.geotab.model.serialization.SourceSerializer;
import com.geotab.model.serialization.SystemEntitySerializationAware;
import com.geotab.util.Util;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The source is the underlying producer of the engine data.
 */
@Data
@NoArgsConstructor
@JsonSerialize(using = SourceSerializer.class)
public class Source extends NameEntity implements SystemEntitySerializationAware {

  public Source(String id) {
    this(id, id);
  }

  public Source(String id, String name) {
    setId(new Id(id));
    setName(name);
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }

  public static Source fromSystem(String id) {
    if (Util.isEmpty(id)) return null;

    switch (id) {
      case SOURCE_J1708_ID:
        return SourceJ1708.getInstance();
      case SOURCE_J1939_ID:
        return SourceJ1939.getInstance();
      case SOURCE_OBD_ID:
        return SourceObd.getInstance();
      case SOURCE_GEOTAB_GO_ID:
        return SourceGo.getInstance();
      case SOURCE_SYSTEM_ID:
        return SourceSystem.getInstance();
      case SOURCE_THIRD_PARTY_ID:
        return SourceThirdParty.getInstance();
      case SOURCE_OBD_SA_ID:
        return SourceObdSa.getInstance();
      case SOURCE_PROPRIETARY_ID:
        return SourceProprietary.getInstance();
      case SOURCE_LEGACY_ID:
        return SourceLegacy.getInstance();
      case SOURCE_GMCCC_ID:
        return SourceGmccc.getInstance();
      case SOURCE_BRP_ID:
        return SourceBrp.getInstance();
      case SOURCE_J1708_OBSOLETE_ID:
        return SourceJ1708Obsolete.getInstance();
      case SOURCE_J1939_OBSOLETE_ID:
        return SourceJ1939Obsolete.getInstance();
      case SOURCE_OBD_OBSOLETE_ID:
        return SourceObdObsolete.getInstance();
      case GEOTAB_GO_OBSOLETE_ID:
        return SourceGoObsolete.getInstance();
      case SOURCE_SYSTEM_OBSOLETE_ID:
        return SourceSystemObsolete.getInstance();
      case SOURCE_THIRD_PARTY_OBSOLETE_ID:
        return SourceThirdPartyObsolete.getInstance();
      case SOURCE_OBD_SA_OBSOLETE_ID:
        return SourceObdSaObsolete.getInstance();
      case SOURCE_PROPRIETARY_OBSOLETE_ID:
        return SourceProprietaryObsolete.getInstance();
      case SOURCE_GMCCC_OBSOLETE_ID:
        return SourceGmcccObsolete.getInstance();
      case SOURCE_LEGACY_OBSOLETE_ID:
        return SourceLegacyObsolete.getInstance();
      case SOURCE_BRP_OBSOLETE_ID:
        return SourceBrpObsolete.getInstance();
      case SOURCE_AI_MODEL_ID:
        return SourceAiModel.getInstance();
      case SOURCE_AI_MODEL_OBSOLETE_ID:
        return SourceAiModelObsolete.getInstance();
      case SOURCE_LECV_ID:
        return SourceLevc.getInstance();
      case SOURCE_LECV_OBSOLETE_ID:
        return SourceLevcObsolete.getInstance();
      default:
        return new Source(id, id);
    }
  }
}
