/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the data originated from the AI Model.
 */
@Data
public final class SourceAiModel extends Source {

  private static class InstanceHolder {

    private static final SourceAiModel INSTANCE = new SourceAiModel();
  }

  public static final String SOURCE_AI_MODEL_ID = "SourceAIModelId";

  private SourceAiModel() {
    super(SOURCE_AI_MODEL_ID, "**AI Model");
  }

  public static SourceAiModel getInstance() {
    return InstanceHolder.INSTANCE;
  }
}

