/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the data originated from the AI Model.
 */
@Data
public final class SourceAiModelObsolete extends Source {

  private static class InstanceHolder {

    private static final SourceAiModelObsolete INSTANCE = new SourceAiModelObsolete();
  }

  public static final String SOURCE_AI_MODEL_OBSOLETE_ID = "SourceAiModelObsoleteId";

  private SourceAiModelObsolete() {
    super(SOURCE_AI_MODEL_OBSOLETE_ID, "**AI Model");
  }

  public static SourceAiModelObsolete getInstance() {
    return InstanceHolder.INSTANCE;
  }
}

