/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from a GO device for an obsolete GUID.
 */
@Data
public final class SourceGoObsolete extends Source {

  private static class InstanceHolder {

    private static final SourceGoObsolete INSTANCE = new SourceGoObsolete();
  }

  public static final String GEOTAB_GO_OBSOLETE_ID = "SourceGeotabGoObsoleteId";

  private SourceGoObsolete() {
    super(GEOTAB_GO_OBSOLETE_ID, "**Go Obsolete");
  }

  public static SourceGoObsolete getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
