/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from a J1708 engine computer.
 */
@Data
public final class SourceJ1708 extends Source {

  private static class InstanceHolder {

    private static final SourceJ1708 INSTANCE = new SourceJ1708();
  }

  public static final String SOURCE_J1708_ID = "SourceJ1708Id";

  private SourceJ1708() {
    super(SOURCE_J1708_ID, "**J1708");
  }

  public static SourceJ1708 getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
