/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from a J1939 engine computer.
 */
@Data
public final class SourceJ1939 extends Source {

  private static class InstanceHolder {

    private static final SourceJ1939 INSTANCE = new SourceJ1939();
  }

  public static final String SOURCE_J1939_ID = "SourceJ1939Id";

  private SourceJ1939() {
    super(SOURCE_J1939_ID, "**J1939");
  }

  public static SourceJ1939 getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
