/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from a J1939 engine computer for an obsolete GUID.
 */
@Data
public final class SourceJ1939Obsolete extends Source {

  private static class InstanceHolder {

    private static final SourceJ1939Obsolete INSTANCE = new SourceJ1939Obsolete();
  }

  public static final String SOURCE_J1939_OBSOLETE_ID = "SourceJ1939ObsoleteId";

  private SourceJ1939Obsolete() {
    super(SOURCE_J1939_OBSOLETE_ID, "**J1939 Obsolete");
  }

  public static SourceJ1939Obsolete getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
