/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from a legacy proprietary source for an obsolete GUID.
 */
@Data
public final class SourceLegacyObsolete extends Source {

  private static class InstanceHolder {

    private static final SourceLegacyObsolete INSTANCE = new SourceLegacyObsolete();
  }

  public static final String SOURCE_LEGACY_OBSOLETE_ID = "SourceLegacyObsoleteId";

  private SourceLegacyObsolete() {
    super(SOURCE_LEGACY_OBSOLETE_ID, "**Legacy");
  }

  public static SourceLegacyObsolete getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
