/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from a LEVC source.
 */
@Data
public class SourceLevc extends Source {

  private static class InstanceHolder {

    private static final SourceLevc INSTANCE = new SourceLevc();
  }

  public static final String SOURCE_LECV_ID = "SourceLevcId";

  private SourceLevc() {
    super(SOURCE_LECV_ID, "**Levc");
  }

  public static SourceLevc getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
