/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from an OBD II engine computer for an obsolete GUID.
 */
@Data
public final class SourceObdObsolete extends Source {

  private static class InstanceHolder {

    private static final SourceObdObsolete INSTANCE = new SourceObdObsolete();
  }

  public static final String SOURCE_OBD_OBSOLETE_ID = "SourceObdObsoleteId";

  private SourceObdObsolete() {
    super(SOURCE_OBD_OBSOLETE_ID, "**OBD Obsolete");
  }

  public static SourceObdObsolete getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
