/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from WWH enhanced type.
 */
@Data
public final class SourceObdSa extends Source {

  private static class InstanceHolder {

    private static final SourceObdSa INSTANCE = new SourceObdSa();
  }

  public static final String SOURCE_OBD_SA_ID = "SourceObdSaId";

  private SourceObdSa() {
    super(SOURCE_OBD_SA_ID, "**Obd Sa");
  }

  public static SourceObdSa getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
