/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from WWH enhanced type for an obsolete GUID.
 */
@Data
public final class SourceObdSaObsolete extends Source {

  private static class InstanceHolder {

    private static final SourceObdSaObsolete INSTANCE = new SourceObdSaObsolete();
  }

  public static final String SOURCE_OBD_SA_OBSOLETE_ID = "SourceObdSaObsoleteId";

  private SourceObdSaObsolete() {
    super(SOURCE_OBD_SA_OBSOLETE_ID, "**Obd Sa Obsolete");
  }

  public static SourceObdSaObsolete getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
