/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from proprietary sources.
 */
@Data
public final class SourceProprietary extends Source {

  private static class InstanceHolder {

    private static final SourceProprietary INSTANCE = new SourceProprietary();
  }

  public static final String SOURCE_PROPRIETARY_ID = "SourceProprietaryId";

  private SourceProprietary() {
    super(SOURCE_PROPRIETARY_ID, "**Proprietary");
  }

  public static SourceProprietary getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
