/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from proprietary sources for an obsolete GUID.
 */
@Data
public final class SourceProprietaryObsolete extends Source {

  private static class InstanceHolder {

    private static final SourceProprietaryObsolete INSTANCE = new SourceProprietaryObsolete();
  }

  public static final String SOURCE_PROPRIETARY_OBSOLETE_ID = "SourceProprietaryObsoleteId";

  private SourceProprietaryObsolete() {
    super(SOURCE_PROPRIETARY_OBSOLETE_ID, "**Proprietary Obsolete");
  }

  public static SourceProprietaryObsolete getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
