/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from the MyGeotab system.
 */
@Data
public final class SourceSystem extends Source {

  private static class InstanceHolder {

    private static final SourceSystem INSTANCE = new SourceSystem();
  }

  public static final String SOURCE_SYSTEM_ID = "SourceSystemId";

  private SourceSystem() {
    super(SOURCE_SYSTEM_ID, "**System");
  }

  public static SourceSystem getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
