/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from the MyGeotab system from an obsolete GUID.
 */
@Data
public final class SourceSystemObsolete extends Source {

  private static class InstanceHolder {

    private static final SourceSystemObsolete INSTANCE = new SourceSystemObsolete();
  }

  public static final String SOURCE_SYSTEM_OBSOLETE_ID = "SourceSystemObsoleteId";

  private SourceSystemObsolete() {
    super(SOURCE_SYSTEM_OBSOLETE_ID, "**System Obsolete");
  }

  public static SourceSystemObsolete getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
