/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from a third-party device.
 */
@Data
public final class SourceThirdParty extends Source {

  private static class InstanceHolder {

    private static final SourceThirdParty INSTANCE = new SourceThirdParty();
  }

  public static final String SOURCE_THIRD_PARTY_ID = "SourceThirdPartyId";

  private SourceThirdParty() {
    super(SOURCE_THIRD_PARTY_ID, "**ThirdParty");
  }

  public static SourceThirdParty getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
