/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.statusdata;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The class that represents {@link StatusData} received from a sensor like bluetooth dongle.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "sensorDataBuilder")
public class SensorData extends StatusData {

  /**
   * The MAC address of the sensor.
   */
  private Long address;
}
