package com.geotab.model.entity.tachograph;

import com.geotab.model.entity.Entity;
import com.geotab.model.entity.device.Device;
import com.geotab.model.entity.entitysettings.EntitySetting;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The entity that contains the data for the tachograph vlr data extractor.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class TachographData extends Entity {
  /**
   * Gets or sets the {@link Device}.
   */
  private Device device;

  /**
   * Gets or sets the tachograph version {@link EntitySetting}.
   */
  private EntitySetting tachographVersion;

  /**
   * Gets or sets the vehicle registration number.
   */
  private String vehicleRegistrationNumber;

  /**
   * Gets or sets the tachograph driver name.
   */
  private String tachographDriverName;

  /**
   * Gets or sets the tachograph driver surname.
   */
  private String tachographDriverSurname;

  /**
   * Gets or sets the tachograph co-driver name.
   */
  private String tachographCoDriverName;

  /**
   * Gets or sets the tachograph co-driver surname.
   */
  private String tachographCoDriverSurname;
}
