package com.geotab.model.entity.tachograph;

import com.geotab.model.entity.group.SecurityIdentifier;
import lombok.Data;
import lombok.experimental.SuperBuilder;

/**
 * The entity which describes the tachograph internal request.
 * <isSupported>false</isSupported>
 */
@Data
@SuperBuilder
public class TachographInternalRequest {
  /**
   * Gets or sets list of units.
   */
  public TachographUnitData scope;

  /**
   * Gets or sets the {@link SecurityIdentifier}s to apply.
   */
  public SecurityIdentifier[] securityIdentifiers;

  /**
   * Gets or sets extra data for the TachoModule request.
   */
  public Object data;

  /**
   * Initializes a new instance of the {@link TachographInternalRequest} class.
   */
  public TachographInternalRequest() {
    securityIdentifiers = new SecurityIdentifier[] {};
  }
}
