package com.geotab.model.entity.tachograph;

import com.geotab.model.Id;
import com.geotab.model.entity.groupfilter.GroupFilterCondition;
import lombok.Data;
import lombok.experimental.SuperBuilder;

/**
 * The entity with the TachoModule unit information.
 * <isSupported>false</isSupported>
 */
@Data
@SuperBuilder
public class TachographUnitData {
  /**
   * Gets or sets the unit type name.
   */
  public String unitName;

  /**
   * Gets or sets the list of unit ids.
   */
  public Id[] unitIds;

  /**
   * Gets or sets the group filter.
   */
  public GroupFilterCondition groupFilter;

  /**
   * Initializes a new instance of the {@link TachographUnitData} class.
   */
  public TachographUnitData() {
    unitName = "";
  }
}
