package com.geotab.model.entity.tachograph.companycards;

import com.geotab.model.entity.Entity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Represents a tachograph company card used to identify transport companies in EU countries.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class TachographCompanyCard extends Entity {
  /**
   * Gets or sets the ICC number of the card.
   */
  public Long icc;

  /**
   * Gets or sets the company name of the card.
   */
  public String companyName;

  /**
   * Gets or sets the company's address.
   */
  public String address;

  /**
   * Gets or sets the validity of the card.
   */
  public LocalDateTime validity;

  /**
   * Gets or sets the expiry of the card.
   */
  public LocalDateTime expiry;

  /**
   * Gets or sets the card number.
   */
  public String cardNumber;

  /**
   * Gets or sets the card authority.
   */
  public String cardAuthority;

  /**
   * Gets or sets the source of the card.
   */
  public String source;

  /**
   * Gets or sets the last time this card was updated.
   */
  public LocalDateTime lastUpdate;

  /**
   * Gets or sets the time this card was registered on the system.
   */
  public LocalDateTime registrationTime;

  /**
   * Gets or sets the status of the card.
   * The available values are:
   * <list>
   * <item>
   * <description>"Available": Company card available.</description>
   * </item>
   * <item>
   * <description>"Busy": Company card authenticating.</description>
   * </item>
   * <item>
   * <description>"Offline": Company card disconnected.</description>
   * </item>
   * </list>
   */
  public String status;
}
