package com.geotab.model.entity.tachograph.companycards;

import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Getter
public enum TachographCompanyCardStatus {
  /**
   * Company card disconnected.
   */
  Offline("Offline"),

  /**
   * Company card available.
   */
  Available("Available"),

  /**
   * Company card authenticating.
   */
  Busy("Busy");

  private final String name;

  TachographCompanyCardStatus(String name) {
    this.name = name;
  }
}
