package com.geotab.model.entity.tachograph.files;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The entity which describes the tachograph file.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class TachographModuleDtcoUploadContent {
  /**
   * Gets or sets the iGestion file id.
   */
  public Integer id;

  /**
   * Gets or sets the iGestion company id.
   */
  public Integer companyId;

  /**
   * Gets or sets the id of the file.
   */
  public String geotabFileId;

  /**
   * Gets or sets the assigment info.
   */
  public String assignmentInfo;

  /**
   * Gets or sets the TGD file name.
   */
  public String fileNameTgd;

  /**
   * Gets or sets the DDD file name.
   */
  public String fileNameDdd;

  /**
   * Gets or sets the V1B file name.
   */
  public String fileNameV1B;

  /**
   * Gets or sets the summary.
   */
  public String summary;

  /**
   * Initializes a new instance of the {@link TachographModuleDtcoUploadContent} class.
   *
   * @param assignmentInfo The assignment information.
   * @param summary The summary.
   */
  public TachographModuleDtcoUploadContent(String assignmentInfo, String summary) {
    this.assignmentInfo = assignmentInfo;
    this.summary = summary;
  }
}
