package com.geotab.model.entity.tachograph.files;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.serialization.ByteArrayDeserializer;
import com.geotab.model.serialization.ByteArraySerializer;
import lombok.Data;
import lombok.experimental.SuperBuilder;

/**
 * The entity which describes the tachograph file.
 */
@Data
@SuperBuilder
public class TachographRawDataFile {
  /**
   * Gets or sets the description of the origin of the file.
   */
  public String originDescription;

  /**
   * Gets or sets the file name.
   */
  public String fileName;

  /**
   * Gets or sets the binary data.
   */
  @JsonDeserialize(using = ByteArrayDeserializer.class)
  @JsonSerialize(using = ByteArraySerializer.class)
  public Byte[] binaryData;

  /**
   * Initializes a new instance of the {@link TachographRawDataFile} class.
   */
  public TachographRawDataFile() {
    this.originDescription = "";
    this.fileName = "";
    this.binaryData = new Byte[] {};
  }
}
