package com.geotab.model.entity.tachograph.files;

import com.geotab.model.entity.Entity;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The entity which describes the tachograph file.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class TachographRawDataFileResult extends Entity {
  /**
   * Gets or sets the assigment info.
   */
  public String assignmentInfo;

  /**
   * Gets or sets the TGD file name.
   */
  public String fileNameTgd;

  /**
   * Gets or sets the DDD file name.
   */
  public String fileNameDdd;

  /**
   * Gets or sets the V1B file name.
   */
  public String fileNameV1B;

  /**
   * Gets or sets the summary.
   */
  public String summary;
}
