/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.textmessage;

import static com.geotab.util.Util.listOf;

import java.util.List;
import java.util.Optional;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Text message content including a list of predetermined responses. Derived from {@link TextContent}.
 */
@Data
@NoArgsConstructor
public class CannedResponseContent extends TextContent {

  /**
   * The address of the stop.
   */
  private List<CannedResponseOption> cannedResponseOptions;

  @Builder(builderMethodName = "cannedResponseContentBuilder")
  public CannedResponseContent(String message, Boolean urgent,
      List<CannedResponseOption> cannedResponseOptions) {
    super(MessageContentType.CANNED_RESPONSE, message, urgent);
    this.cannedResponseOptions = Optional.ofNullable(cannedResponseOptions).orElse(listOf());
  }
}
