/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.textmessage;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Specifies the allowed responses to a {@link TextMessage}.
 */
@Data
@NoArgsConstructor()
public class CannedResponseOption {

  /**
   * The id number of the reply or null.
   */
  private Integer id;
  /**
   * The text options provided for the CannedResponse message reply.
   */
  private String text;

  @Builder
  public CannedResponseOption(Integer id, String text) {
    this.id = id;
    this.text = text;
  }

  public CannedResponseOption(String text) {
    this.text = text;
  }
}
