/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.textmessage;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Message that can deliver data to a component of a GO device.
 */
@Data
@NoArgsConstructor
public abstract class DataToComponentContent extends TextMessageContentType {

  /**
   * The component type's index, for example, AUX 5 on an auxiliary expansion port.
   */
  @JsonIgnore
  private int componentIndex;

  /**
   * The component type being addressed.
   */
  @JsonIgnore
  private int componentType;

  /**
   * The tethered device index. GO devices are always index 0.
   */
  @JsonIgnore
  private int deviceIndex;

  /**
   * Gets a value indicating whether get true if the recipient device is required to respond with an acknowledge. False
   * otherwise
   */
  @JsonProperty("isAcknowledgeRequired")
  private boolean isAcknowledgeRequired;

  public DataToComponentContent(MessageContentType contentType,
      int componentIndex, int componentType, int deviceIndex, boolean isAcknowledgeRequired) {
    super(contentType);
    this.componentIndex = componentIndex;
    this.componentType = componentType;
    this.deviceIndex = deviceIndex;
    this.isAcknowledgeRequired = isAcknowledgeRequired;
  }
}
