/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.textmessage;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Builder;
import lombok.Data;

/**
 * The contents of a {@link TextMessage} that can be used to control the state of an IOX-OUTPUT.
 */
@Data
public class IoxOutputContent extends DataToComponentContent {

  /**
   * The value indicating whether the relay state. [true] if the relay is on; otherwise, [false].
   */
  @JsonProperty("isRelayOn")
  private boolean isRelayOn;

  @Builder(builderMethodName = "ioxOutputContentBuilder")
  public IoxOutputContent(boolean isRelayOn) {
    super(MessageContentType.IOX_OUTPUT, 2, 6, 0, true);
    this.isRelayOn = isRelayOn;
  }

  public IoxOutputContent() {
    super(MessageContentType.IOX_OUTPUT, 2, 6, 0, true);
  }
}
